// USB RLY08 TESTDlg.cpp : implementation file
//

#include "stdafx.h"
#include "USB_RLY08_TEST.h"
#include "USB RLY08 TESTDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

enum cmds { GET_VER = 90, GET_STATES, SET_STATES,
			ALL_ON=100, RELAY1_ON, RELAY2_ON, RELAY3_ON, RELAY4_ON, RELAY5_ON, RELAY6_ON, RELAY7_ON, RELAY8_ON,
			ALL_OFF=110, RELAY1_OFF, RELAY2_OFF, RELAY3_OFF, RELAY4_OFF, RELAY5_OFF, RELAY6_OFF, RELAY7_OFF, RELAY8_OFF
};

HANDLE hCom;		//handle for com port data
char module_id = 0;
char com_selection = 0;
int relay_states = 0;
int software_version = 0;


/////////////////////////////////////////////////////////////////////////////
// CUSBRLY08TESTDlg dialog

CUSBRLY08TESTDlg::CUSBRLY08TESTDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CUSBRLY08TESTDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CUSBRLY08TESTDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CUSBRLY08TESTDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CUSBRLY08TESTDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CUSBRLY08TESTDlg, CDialog)
	//{{AFX_MSG_MAP(CUSBRLY08TESTDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_RELAY1, OnRelay1)
	ON_BN_CLICKED(IDC_RELAY2, OnRelay2)
	ON_BN_CLICKED(IDC_RELAY3, OnRelay3)
	ON_BN_CLICKED(IDC_RELAY4, OnRelay4)
	ON_BN_CLICKED(IDC_RELAY5, OnRelay5)
	ON_BN_CLICKED(IDC_RELAY6, OnRelay6)
	ON_BN_CLICKED(IDC_RELAY7, OnRelay7)
	ON_BN_CLICKED(IDC_RELAY8, OnRelay8)
	ON_CBN_SELCHANGE(IDC_COMPORTS, OnSelchangeComports)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_ALL_ON, OnAllOn)
	ON_BN_CLICKED(IDC_ALL_OFF, OnAllOff)
	ON_BN_CLICKED(IDC_BIT_PATTERN, OnBitPattern)
	ON_BN_CLICKED(IDC_BIT_PATTERN2, OnBitPattern2)
	ON_WM_SHOWWINDOW()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUSBRLY08TESTDlg message handlers

BOOL CUSBRLY08TESTDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon 
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM1");	//places text comm(x) into drop down selection box
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM2");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM3");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM4");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM5");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM6");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM7");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM8");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM9");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM10");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM11");
	((CComboBox*) GetDlgItem(IDC_COMPORTS))->AddString("COM12");
	CWinApp* App = AfxGetApp();											//setup pointer to memory
	com_selection = App->GetProfileInt("SETTINGS","COMPORT",0);			//and retrieve last com port selection
	change_com_port();													//setup new com port
	((CComboBox*)GetDlgItem(IDC_COMPORTS))->SetCurSel(com_selection);	//change dialog box (IDC_COMPORTS) to show selected com port
	SetTimer(1, 1000, 0);												//timer set to 1s, OnTimer routine called once/sec 
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CUSBRLY08TESTDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CUSBRLY08TESTDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CUSBRLY08TESTDlg::OnRelay1()	//function is called on press of radio button "RELAY1"
{
	if(relay_states & 0x01) {		//decides wether relay is already on or off
		SerOut(RELAY1_OFF);			//relay1 was on so button press sends off command
		relay_states &= 0xFE;
	}
	else {
		SerOut(RELAY1_ON);			//relay1 was off so button press sends on command
		relay_states |= 0x01;
	}
	print_relay_states();			//routine that updates the radio buttons and relay states on the dialog box
}

void CUSBRLY08TESTDlg::OnRelay2()	//function is called on press of radio button "RELAY2"
{
	if(relay_states & 0x02) {
		SerOut(RELAY2_OFF);
		relay_states &= 0xFD;
	}
	else {
		SerOut(RELAY2_ON);
		relay_states |= 0x02;
	}
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnRelay3()	//function is called on press of radio button "RELAY3"
{
	if(relay_states & 0x04) { 
		SerOut(RELAY3_OFF);
		relay_states &= 0xFB;
	}
	else {
		SerOut(RELAY3_ON);	
		relay_states |= 0x04;
	}	
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnRelay4()	//function is called on press of radio button "RELAY4"
{
	if(relay_states & 0x08) {
		SerOut(RELAY4_OFF);
		relay_states &= 0xF7;
	}
	else {
		SerOut(RELAY4_ON);
		relay_states |= 0x08;
	}
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnRelay5()	//function is called on press of radio button "RELAY5"
{
	if(relay_states & 0x10) {
		SerOut(RELAY5_OFF);
		relay_states &= 0xEF;
	}
	else {
		SerOut(RELAY5_ON);
		relay_states |= 0x10;
	}	
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnRelay6()	//function is called on press of radio button "RELAY6"
{
	if(relay_states & 0x20) {
		SerOut(RELAY6_OFF);
		relay_states &= 0xDF;
	}
	else {
		SerOut(RELAY6_ON);	
		relay_states |= 0x20;
	}	
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnRelay7()	//function is called on press of radio button "RELAY7"
{
	if(relay_states & 0x40) {
		SerOut(RELAY7_OFF);
		relay_states &= 0xBF;
	}
	else {
		SerOut(RELAY7_ON);
		relay_states |= 0x40;
	}	
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnRelay8()	//function is called on press of radio button "RELAY8"
{
	if(relay_states & 0x80)	{
		SerOut(RELAY8_OFF);
		relay_states &= 0x7F;
	}
	else {
		SerOut(RELAY8_ON);
		relay_states |= 0x80;
	} 	
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnAllOn()	//function is called on press of button "ALL ON"
{
	SerOut(ALL_ON);
	relay_states = 255;
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnAllOff() 	//function is called on press of button "ALL OFF"
{
	SerOut(ALL_OFF);
	relay_states = 0;
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnBitPattern() 	//function is called on press of button "01010101"
{
	relay_states = 0x55;	//bit pattern for 01010101
	SerOut(SET_STATES);
	SerOut(relay_states);
	print_relay_states();
}

void CUSBRLY08TESTDlg::OnBitPattern2() 	//function is called on press of button "10101010"
{
	relay_states = 0xAA;	//bit pattern for 10101010
	SerOut(SET_STATES);
	SerOut(relay_states);
	print_relay_states();
	
}

void CUSBRLY08TESTDlg::SetupCommPort( LPCTSTR comport)
{
	DCB dcb;
	COMMTIMEOUTS ct;

	CloseHandle(hCom);
	hCom = CreateFile( comport, GENERIC_READ | GENERIC_WRITE, 0, 0, OPEN_EXISTING, 0, 0);
	GetCommState(hCom, &dcb);
	dcb.BaudRate = CBR_19200;
	dcb.fParity = FALSE;
	dcb.fOutxCtsFlow = FALSE;
	dcb.fOutxDsrFlow = FALSE;
	dcb.fDtrControl = DTR_CONTROL_DISABLE;
	dcb.fDsrSensitivity = FALSE;
	dcb.fOutX = FALSE;
	dcb.fInX = FALSE;
	dcb.fRtsControl = RTS_CONTROL_DISABLE;
	dcb.fAbortOnError = FALSE;
	dcb.ByteSize = 8;
	dcb.Parity = NOPARITY;
	dcb.StopBits = TWOSTOPBITS;
	SetCommState(hCom, &dcb);
  
	GetCommTimeouts(hCom, &ct);
	ct.ReadIntervalTimeout = 150;
    ct.ReadTotalTimeoutMultiplier = 150; 
    ct.ReadTotalTimeoutConstant = 150; 
	SetCommTimeouts(hCom, &ct);

	SetCommMask(hCom, EV_RXCHAR);
}

void CUSBRLY08TESTDlg::OnSelchangeComports()		//funtion called when there is a change of com port in the dialog box
{
	com_selection = ((CComboBox*) GetDlgItem(IDC_COMPORTS))->GetCurSel();	//read what the com port has been changed to
	change_com_port();														//and change accordingly
}

void CUSBRLY08TESTDlg::SerOut(BYTE sbuf)	
{
DWORD n;
    WriteFile(hCom, &sbuf, 1, &n, NULL);	//library function to write to a location, in this case the com port defined by handle hcom
}


BYTE CUSBRLY08TESTDlg::SerIn(void)			
{
BYTE sbuf;
DWORD n;
	ReadFile(hCom, &sbuf, 1, &n, NULL);		//library function to read a location, in this case the com port defined by handle hcom
	return sbuf;
}

void CUSBRLY08TESTDlg::change_com_port(void)	//routine takes selection between 0 and 11 passed from either the init routine or
{												//change of com port routine and calls SetupCommPort with appropriate string
	switch(com_selection){	
		case 0: SetupCommPort("COM1"); break;
		case 1: SetupCommPort("COM2"); break;
		case 2: SetupCommPort("COM3"); break;
		case 3: SetupCommPort("COM4"); break;
		case 4: SetupCommPort("COM5"); break;
		case 5: SetupCommPort("COM6"); break;
		case 6: SetupCommPort("COM7"); break;
		case 7: SetupCommPort("COM8"); break;
		case 8: SetupCommPort("COM9"); break;
		case 9: SetupCommPort("\\\\.\\com10"); break;			//comm ports above 9 need the \\\\.\\comx form
		case 10: SetupCommPort("\\\\.\\com11"); break;
		case 11: SetupCommPort("\\\\.\\com12"); break;
	}
	CWinApp* App = AfxGetApp(); 
	App->WriteProfileInt("SETTINGS","COMPORT",com_selection);	
}

void CUSBRLY08TESTDlg::OnTimer(UINT nIDEvent)		//checks for USB RL08 every 1s
{
CString s;
static char last_ver = 0;
		
	SerOut(GET_VER);
	module_id = SerIn();
	software_version = SerIn();
	if(module_id != 8) {							//no USB RLY08 connected
		SetDlgItemText( IDC_STATUSBAR, "Searching for RLY08" );
		SetDlgItemText( IDC_VER,"");				//clear dialog boxes and radio buttons
		SetDlgItemText( IDC_RELAY_STATES,"");
		((CButton*)GetDlgItem(IDC_RELAY1))->SetCheck(0);	
		((CButton*)GetDlgItem(IDC_RELAY2))->SetCheck(0);
		((CButton*)GetDlgItem(IDC_RELAY3))->SetCheck(0);
		((CButton*)GetDlgItem(IDC_RELAY4))->SetCheck(0);
		((CButton*)GetDlgItem(IDC_RELAY5))->SetCheck(0);
		((CButton*)GetDlgItem(IDC_RELAY6))->SetCheck(0);
		((CButton*)GetDlgItem(IDC_RELAY7))->SetCheck(0);
		((CButton*)GetDlgItem(IDC_RELAY8))->SetCheck(0);
		change_com_port();									
	}
	else {											//USB RLY08 connected
		SetDlgItemText( IDC_STATUSBAR, "RLY08 found" );	
		s.Format("%i ", software_version);
		SetDlgItemText( IDC_VER,s);

		if(last_ver != software_version){	//first time round so retrieve relay states		
			SerOut(GET_STATES);
			relay_states = SerIn();
			print_relay_states();
		}
	}
	last_ver = software_version;
	CDialog::OnTimer(nIDEvent);
}

void CUSBRLY08TESTDlg:: print_relay_states(void)	//routine updates the radio buttons and relay states on the dialog box
{
CString s;
byte t[9];
byte x;

	if(module_id == 8) {			//indicates if RLY08 is connected to enable dialog boxes and radio buttons
		for(x=0; x<8; x++) t[x] = '0';
		t[8] = 0;
		if(relay_states & 0x01){
			((CButton*)GetDlgItem(IDC_RELAY1))->SetCheck(1);	
			t[7] = '1';
		}
		else ((CButton*)GetDlgItem(IDC_RELAY1))->SetCheck(0);

		if(relay_states & 0x02){
			((CButton*)GetDlgItem(IDC_RELAY2))->SetCheck(1);
			t[6] = '1';
		}
		else ((CButton*)GetDlgItem(IDC_RELAY2))->SetCheck(0);

		if(relay_states & 0x04){
			((CButton*)GetDlgItem(IDC_RELAY3))->SetCheck(1);
			t[5] = '1';
		}		
		else ((CButton*)GetDlgItem(IDC_RELAY3))->SetCheck(0);

		if(relay_states & 0x08){
			((CButton*)GetDlgItem(IDC_RELAY4))->SetCheck(1);
			t[4] = '1';
		}
		else ((CButton*)GetDlgItem(IDC_RELAY4))->SetCheck(0);

		if(relay_states & 0x10){
			((CButton*)GetDlgItem(IDC_RELAY5))->SetCheck(1);
			t[3] = '1';
		}
		else ((CButton*)GetDlgItem(IDC_RELAY5))->SetCheck(0);

		if(relay_states & 0x20){
			((CButton*)GetDlgItem(IDC_RELAY6))->SetCheck(1);
			t[2] = '1';
		}
		else ((CButton*)GetDlgItem(IDC_RELAY6))->SetCheck(0);

		if(relay_states & 0x40){
			((CButton*)GetDlgItem(IDC_RELAY7))->SetCheck(1);
			t[1] = '1';
		}
		else ((CButton*)GetDlgItem(IDC_RELAY7))->SetCheck(0);

		if(relay_states & 0x80){
			((CButton*)GetDlgItem(IDC_RELAY8))->SetCheck(1);
			t[0] = '1';
		}
		else ((CButton*)GetDlgItem(IDC_RELAY8))->SetCheck(0);

		s = t;
		SetDlgItemText( IDC_RELAY_STATES,s);
	}
}





void CUSBRLY08TESTDlg::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	// TODO: Add your message handler code here
	
}
